# 画面設計書 45-kubeadm init

## 概要

本ドキュメントは、kubeadmのinitコマンドの画面設計書である。Kubernetesコントロールプレーンノードを初期化し、クラスタを構築するためのCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Kubernetesクラスタを新規構築する際、コントロールプレーンノードの初期化は最初に実行される最も重要なステップである。kubeadm initコマンドは、証明書の生成、kubeconfigファイルの作成、etcdの起動、コントロールプレーンコンポーネントの起動、ブートストラップトークンの作成、アドオン（CoreDNS, kube-proxy）のデプロイを一連のフェーズとして実行する。

**画面へのアクセス方法**：ターミナルから `kubeadm init [flags]` を実行する。root権限が必要。

**主要な操作・処理内容**：
1. Preflight（事前検証）フェーズ：ノードの前提条件を検証
2. Certs（証明書）フェーズ：CA証明書およびコンポーネント証明書を生成
3. KubeConfig フェーズ：admin.conf, controller-manager.conf等のkubeconfigファイルを生成
4. Etcd フェーズ：etcdの静的Podマニフェストを生成
5. ControlPlane フェーズ：API Server, Controller Manager, Schedulerの静的Podマニフェストを生成
6. KubeletStart フェーズ：kubeletを起動・設定
7. WaitControlPlane フェーズ：コントロールプレーンコンポーネントの起動を待機
8. UploadConfig フェーズ：kubeadm設定をConfigMapにアップロード
9. UploadCerts フェーズ：証明書をSecretにアップロード（オプション）
10. MarkControlPlane フェーズ：ノードにコントロールプレーンラベルとtaintを付与
11. BootstrapToken フェーズ：ブートストラップトークンを作成
12. KubeletFinalize フェーズ：kubeletの設定を最終化
13. Addon フェーズ：CoreDNSとkube-proxyをデプロイ
14. ShowJoinCommand フェーズ：ノード参加用のコマンドを表示

**画面遷移**：init完了後、表示されるjoinコマンドを使用して他のノードをクラスタに参加させる（kubeadm join）。

**権限による表示制御**：root権限が必要。--dry-runフラグでroot不要のシミュレーション実行が可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 主機能 | コントロールプレーンノードの初期設定とクラスター構築を行う主処理 |
| 121 | 証明書管理 | 補助機能 | init実行時にクラスター内の各種TLS証明書を自動生成する |
| 1 | API Serverコア | API連携 | 初期化完了後にAPI Serverが起動しAPIエンドポイントが利用可能になる |

## 画面種別

ワークフロー実行（CLIフェーズ実行型）

## URL/ルーティング

```
kubeadm init [flags]
kubeadm init phase <phase-name> [flags]
```

## 入出力項目

### 入力項目（フラグ）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --apiserver-advertise-address | string | 任意 | 自動検出 | API Serverのアドバタイズアドレス |
| --apiserver-bind-port | int32 | 任意 | 6443 | API Serverのバインドポート |
| --node-name | string | 任意 | ホスト名 | ノード名 |
| --certificate-key | string | 任意 | "" | 証明書暗号化キー（AES 32バイト） |
| --cri-socket | string | 任意 | 自動検出 | CRIソケットパス |
| --service-cidr | string | 任意 | 10.96.0.0/12 | Service VIP用IPレンジ |
| --pod-network-cidr | string | 任意 | "" | Pod用IPレンジ |
| --service-dns-domain | string | 任意 | cluster.local | DNSドメイン |
| --control-plane-endpoint | string | 任意 | "" | コントロールプレーンの安定エンドポイント |
| --kubernetes-version | string | 任意 | 自動取得 | Kubernetesバージョン |
| --cert-dir | string | 任意 | /etc/kubernetes/pki | 証明書ディレクトリ |
| --apiserver-cert-extra-sans | []string | 任意 | [] | API Server証明書の追加SAN |
| --feature-gates | string | 任意 | "" | Feature Gateの設定 |
| --config | string | 任意 | "" | 設定ファイルパス |
| --ignore-preflight-errors | []string | 任意 | [] | 無視するpreflight検査 |
| --skip-token-print | bool | 任意 | false | トークン表示をスキップ |
| --dry-run | bool | 任意 | false | ドライラン実行 |
| --upload-certs | bool | 任意 | false | 証明書をSecretにアップロード |
| --skip-certificate-key-print | bool | 任意 | false | 証明書キー表示をスキップ |
| --patches | string | 任意 | "" | パッチファイルディレクトリ |
| --token | string | 任意 | 自動生成 | ブートストラップトークン |
| --token-ttl | duration | 任意 | 24h | トークンの有効期限 |
| --image-repository | string | 任意 | registry.k8s.io | イメージリポジトリ |
| --skip-phases | []string | 任意 | [] | スキップするフェーズ |

### 出力項目

各フェーズの実行結果がステップバイステップで標準出力に表示される。最終的にjoinコマンドが表示される。

## 表示項目

```
[init] Using Kubernetes version: v1.x.x
[preflight] Running pre-flight checks
[certs] Generating "ca" certificate and key
[certs] Generating "apiserver" certificate and key
...
[kubeconfig] Writing "admin.conf" kubeconfig file
...
[kubelet-start] Writing kubelet configuration
...
[control-plane] Creating static Pod manifest for "kube-apiserver"
...
[addons] Applied essential addon: CoreDNS
[addons] Applied essential addon: kube-proxy

Your Kubernetes control-plane has initialized successfully!

To start using your cluster, you need to run:
  mkdir -p $HOME/.kube
  sudo cp -i /etc/kubernetes/admin.conf $HOME/.kube/config
  ...

kubeadm join <endpoint>:<port> --token <token> --discovery-token-ca-cert-hash sha256:<hash>
```

## イベント仕様

### 1-initコマンド実行

1. `newCmdInit` でworkflow.Runnerを作成し、14のフェーズを順次登録
2. `SetDataInitializer` で設定のロードとバリデーションを実行
3. `initRunner.Run(args)` で全フェーズを順次実行
4. 各フェーズは独立して実行可能（`kubeadm init phase <phase>`）

### 2-データ初期化（newInitData）

1. デフォルト値の適用
2. Feature Gateの検証
3. 設定ファイルのロードまたはフラグからの内部設定への変換
4. Preflight検査エラーの設定
5. DryRunモードの処理
6. 外部CA使用の検出と検証

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Certs フェーズ | ファイルシステム(/etc/kubernetes/pki) | CREATE | CA証明書とコンポーネント証明書を生成 |
| KubeConfig フェーズ | ファイルシステム(/etc/kubernetes) | CREATE | admin.conf等のkubeconfigファイルを生成 |
| Etcd フェーズ | ファイルシステム(static pod) | CREATE | etcd静的Podマニフェストを作成 |
| ControlPlane フェーズ | ファイルシステム(static pod) | CREATE | コントロールプレーン静的Podマニフェストを作成 |
| UploadConfig フェーズ | ConfigMap (kube-system/kubeadm-config) | INSERT | kubeadm設定をConfigMapに保存 |
| UploadCerts フェーズ | Secret (kube-system/kubeadm-certs) | INSERT | 証明書をSecretに保存（--upload-certs時） |
| BootstrapToken フェーズ | Secret (kube-system/bootstrap-token-*) | INSERT | ブートストラップトークンを作成 |
| Addon フェーズ | Deployment/ConfigMap等 | INSERT | CoreDNSとkube-proxyをデプロイ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| INFO-01 | 情報 | `[init] Using Kubernetes version: %s` | 正常実行時 |
| ERR-01 | エラー | `invalid or incomplete external CA` | 外部CA使用時に証明書不足 |
| ERR-02 | エラー | `can't use upload-certs with an external CA...` | 外部CA+upload-certsの組み合わせ |
| ERR-03 | エラー | `invalid data struct` | 内部データ構造エラー |

## 例外処理

- Preflight検査失敗時は`--ignore-preflight-errors`で無視可能
- 外部CA使用時に証明書が不足している場合はエラー終了
- DryRunモードでは一時ディレクトリに出力し、実際のシステム変更は行わない
- CRIソケットの自動検出に失敗した場合は明示的な指定が必要

## 備考

- 14のフェーズはworkflow.Runnerにより管理され、`--skip-phases`で個別にスキップ可能
- DNS/Proxy AddonのDisabled設定とskipPhasesは相互に同期される（manageSkippedAddons関数）
- 外部CA/外部Front-Proxy CAの検出は証明書ファイルの存在チェックで行われる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | initOptions構造体（行58-73）がコマンドラインオプションを保持する。externalInitCfgとexternalClusterCfgがパブリックAPI型 |
| 1-2 | init.go | `cmd/kubeadm/app/cmd/init.go` | initData構造体（行91-108）がワークフロー実行時のランタイムデータを保持する。全フェーズで共有される |

**読解のコツ**: kubeadmはpublic API型（v1beta4）と内部型の変換を行う。configutil.LoadOrDefaultInitConfigurationが変換の中心。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | newCmdInit関数（行113-199）がcobra.Commandを構築。行158-171で14のフェーズを順次登録している |

**主要処理フロー**:
1. **行117**: workflow.NewRunner()でランナー作成
2. **行122-136**: RunE内でInitData→Runの順序
3. **行142-155**: フラグ登録
4. **行158-171**: 14フェーズの登録
5. **行175-192**: DataInitializerの設定

#### Step 3: データ初期化を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | init.go | `cmd/kubeadm/app/cmd/init.go` | newInitData関数（行308-410）がオプションのバリデーションと内部設定への変換を行う。行330でLoadOrDefaultInitConfigurationを呼び出す |

#### Step 4: フェーズの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | phases/init/ | `cmd/kubeadm/app/cmd/phases/init/` | 各フェーズの実装。preflightphase.go, certsphase.go等 |

### プログラム呼び出し階層図

```
newCmdInit (init.go:113)
    |
    +-- workflow.Runner.Run()
           |
           +-- NewPreflightPhase → preflight検査
           +-- NewCertsPhase → 証明書生成
           +-- NewKubeConfigPhase → kubeconfig生成
           +-- NewEtcdPhase → etcd静的Pod
           +-- NewControlPlanePhase → CP静的Pod
           +-- NewKubeletStartPhase → kubelet起動
           +-- NewWaitControlPlanePhase → CP待機
           +-- NewUploadConfigPhase → 設定アップロード
           +-- NewUploadCertsPhase → 証明書アップロード
           +-- NewMarkControlPlanePhase → ラベル/taint付与
           +-- NewBootstrapTokenPhase → トークン作成
           +-- NewKubeletFinalizePhase → kubelet最終化
           +-- NewAddonPhase → CoreDNS/kube-proxy
           +-- NewShowJoinCommandPhase → joinコマンド表示
```

### データフロー図

```
[入力]                    [処理]                    [出力]

フラグ/設定ファイル ──> newInitData() ──> initData
                          |
                    workflow.Runner.Run()
                          |
                    各フェーズ実行 ──────> 証明書ファイル
                                         kubeconfigファイル
                                         静的Podマニフェスト
                                         ConfigMap/Secret
                                         stdout (進捗表示)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| init.go | `cmd/kubeadm/app/cmd/init.go` | ソース | initコマンド本体の実装 |
| phases/init/ | `cmd/kubeadm/app/cmd/phases/init/` | ソース | 各フェーズの実装 |
| workflow/ | `cmd/kubeadm/app/cmd/phases/workflow/` | ソース | フェーズワークフローランナー |
| options/ | `cmd/kubeadm/app/cmd/options/` | ソース | フラグ定義ヘルパー |
| v1beta4/ | `cmd/kubeadm/app/apis/kubeadm/v1beta4/` | ソース | パブリックAPI型定義 |
| config/ | `cmd/kubeadm/app/util/config/` | ソース | 設定ロード・変換ユーティリティ |
| constants/ | `cmd/kubeadm/app/constants/` | ソース | 定数定義 |
